﻿using System;
using System.Collections.Generic;
using System.Text;

#if DEBUG
using System.IO;
#endif

namespace Asteroid
  {
  class GameStatus
    {
    private const int MAX_ASTEROIDS = 100;
    private const int MAX_SHOTS = 10;
    private StarShip m_Ship = new StarShip();
    private UnidentifiedFlyingObject m_Ufo = new UnidentifiedFlyingObject();

    /// <summary>
    /// Initializes a new instance of the <see cref="GameStatus"/> class.
    /// </summary>
    /// ****************************************************************************************************
    /// * Datum: 17.04.2008 21:25
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public GameStatus()
      {
      for (int i = 0; i < MAX_ASTEROIDS; i++)
        m_arrAsteroids[i] = new Asteroid();

      for (int i = 0; i < MAX_SHOTS; i++)
        m_arrShots[i] = new Shot();
      }

    private bool m_bShipPresent = false;
    /// <summary>
    /// Gets or sets a value indicating whether this instance is ship present.
    /// </summary>
    /// <value>
    /// 	<c>true</c> if this instance is ship present; otherwise, <c>false</c>.
    /// </value>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 22:19
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public bool IsShipPresent
      {
      get
        {
        return m_bShipPresent;
        }
      set
        {
        m_bShipPresent = value;
        }
      }

    private bool m_bUfoPresent = false;
    /// <summary>
    /// Gets or sets a value indicating whether [ufo present].
    /// </summary>
    /// <value><c>true</c> if [ufo present]; otherwise, <c>false</c>.</value>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 22:31
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public bool IsUfoPresent
      {
      get
        {
        return m_bUfoPresent;
        }
      set
        {
        m_bUfoPresent = value;
        }
      }

    /// <summary>
    /// Gets or sets the ufo.
    /// </summary>
    /// <value>The ufo.</value>
    /// ****************************************************************************************************
    /// * Datum: 19.04.2008 18:42
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public UnidentifiedFlyingObject Ufo
      {
      get
        {
        return m_Ufo;
        }
      set
        {
        m_Ufo = value;
        }
      }

    /// <summary>
    /// Gets or sets my ship.
    /// </summary>
    /// <value>My ship.</value>
    /// ****************************************************************************************************
    /// * Datum: 19.04.2008 21:48
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public StarShip MyShip
      {
      get
        {
        return m_Ship;
        }
      set
        {
        m_Ship = value;
        }
      }

    private int m_iCountAsteroids = 0;
    /// <summary>
    /// Gets or sets the count asteroids.
    /// </summary>
    /// <value>The count asteroids.</value>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 22:37
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public int CountAsteroids
      {
      get
        {
        return m_iCountAsteroids;
        }
      set
        {
        m_iCountAsteroids = value;
        }
      }

    private Asteroid[] m_arrAsteroids = new Asteroid[MAX_ASTEROIDS];
    /// <summary>
    /// Gets or sets the asteroids.
    /// </summary>
    /// <value>The asteroids.</value>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 22:41
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public Asteroid[] Asteroids
      {
      get
        {
        return m_arrAsteroids;
        }
      set
        {
        m_arrAsteroids = value;
        }
      }

    private int m_iCountShuts = 0;
    /// <summary>
    /// Gets or sets the count shuts.
    /// </summary>
    /// <value>The count shuts.</value>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 22:42
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public int CountShots
      {
      get
        {
        return m_iCountShuts;
        }
      set
        {
        m_iCountShuts = value;
        }
      }

    private Shot[] m_arrShots = new Shot[MAX_SHOTS];
    /// <summary>
    /// Gets or sets the shuts.
    /// </summary>
    /// <value>The shuts.</value>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 22:42
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public Shot[] Shots
      {
      get
        {
        return m_arrShots;
        }
      set
        {
        m_arrShots = value;
        }
      }

    /// <summary>
    /// Clears this instance.
    /// </summary>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 22:43
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public void Clear()
      {
      m_bShipPresent = false;
      m_bUfoPresent = false;
      m_iCountAsteroids = 0;
      m_iCountShuts = 0;
      }

#if DEBUG
    /// <summary>
    /// Writes to file.
    /// </summary>
    /// <param name="strFullPath">The STR full path.</param>
    /// ****************************************************************************************************
    /// * Datum: 17.04.2008 21:39
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public void WriteToFile(string strFullPath)
      {
      int i = 0;

      try
        {
        StreamWriter File = new StreamWriter(strFullPath, true);

        for (i = 0; i < m_iCountAsteroids; i++)
          {
          File.WriteLine("Asteroid {0}: Type {1},  X{2},  Y{3}, SF {4}", i, m_arrAsteroids[i].Type, m_arrAsteroids[i].CurrentPos.X
            , m_arrAsteroids[i].CurrentPos.Y, m_arrAsteroids[i].ScaleFaktor);
          }

        for (i = 0; i < m_iCountShuts; i++)
          {
          File.WriteLine("Shots {0}: X{1},  Y{2}", i, m_arrShots[i].CurrentPos.X, m_arrShots[i].CurrentPos.Y);
          }

        if (m_bShipPresent)
          File.WriteLine("Ship : X{0},  Y{1}, dX{2},  dY{3}", m_Ship.CurrentPos.X, m_Ship.CurrentPos.Y, m_Ship.ShipDirectionX, m_Ship.ShipDirectionY);

        if (m_bUfoPresent)
          File.WriteLine("Ufo : X{0},  Y{1}", m_Ufo.CurrentPos.X, m_Ufo.CurrentPos.Y);



        if (m_iCountAsteroids > 0 || m_iCountShuts > 0)
          File.WriteLine();

        File.Close();
        }
      catch (Exception exp)
        {
        System.Diagnostics.Trace.WriteLine(exp.Message);
        }
      }
#endif
    }
  }
